// Generate blog articles metadata for all 23 services
const services = require('./services.json');

const blogTemplates = [
    { pattern: 'emergency-guide', title: '{Service} Emergency Guide: What to Do Right Now', desc: 'Facing a {service} emergency? Learn the critical steps to take immediately. Need help now? Call Rapid Service Connect for 24/7 professional connection.' },
    { pattern: 'signs-you-need', title: '{X} Signs You Need Emergency {Service}', desc: 'Know the warning signs that require immediate {service} help. Connect with 24/7 professionals instantly via Rapid Service Connect.' },
    { pattern: 'cost-guide', title: '{Service} Cost Guide: What to Expect in 2024', desc: 'Understand typical {service} costs and pricing. Need urgent help? Connect with verified professionals 24/7 through Rapid Service Connect.' },
    { pattern: 'diy-vs-pro', title: 'DIY vs. Professional {Service}: When to Call a Pro', desc: 'Learn which {service} issues you can handle and which require professionals. For emergencies, call Rapid Service Connect immediately.' },
    { pattern: 'what-to-expect', title: 'What to Expect from a 24/7 {Service} Visit', desc: 'First time calling {service}? Here\'s what to expect. Connect instantly with verified pros via Rapid Service Connect.' }
];

const articles = [];

services.forEach(service => {
    const serviceName = service.name.replace('Emergency ', '').replace(' / ', ' ');

    blogTemplates.forEach((template, idx) => {
        const slug = `${service.slug}-${template.pattern}`;
        const title = template.title
            .replace('{Service}', serviceName)
            .replace('{service}', serviceName.toLowerCase())
            .replace('{X}', idx === 1 ? '5' : '');

        const description = template.desc
            .replace(/{service}/g, serviceName.toLowerCase())
            .replace(/{Service}/g, serviceName);

        articles.push({
            service: service.id,
            slug: slug,
            title: title,
            metaDescription: description
        });
    });
});

console.log(JSON.stringify(articles, null, 2));
